/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.coordinator;

import filenet.vw.api.VWException;
import filenet.vw.apps.admin.VWAdminApplication;
import filenet.vw.apps.config.VWConfigApplication;
import filenet.vw.apps.designer.VWDesignerApplication;
import filenet.vw.apps.linker.VWLinkerApplication;
import filenet.vw.apps.manager.VWWorkflowManagerApplication;
import filenet.vw.apps.selectwf.VWSelectWFApplication;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWLaunchableApp;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWCachedSecurityList;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.resources.VWResource;

public class VWLaunchAppHelper
implements Runnable {
    public static final int STATE_NONE = 0;
    public static final int STATE_CREATE_ADMIN_APP = 1;
    public static final int STATE_CREATE_CONFIG_APP = 2;
    public static final int STATE_CREATE_DESIGNER_APP = 3;
    public static final int STATE_CREATE_LINKER_APP = 4;
    public static final int STATE_CREATE_MANAGER_APP = 5;
    public static final int STATE_CREATE_PUBLISH_APP = 6;
    public static final int STATE_CREATE_SEARCH_APP = 7;
    public static final int STATE_CREATE_SELECTWF_APP = 8;
    public static final int STATE_LOGOFF = 21;
    public static final int STATE_DESTROY = 22;
    private int m_nState = 0;
    private VWBaseAppLauncherApplet m_launcherApplet = null;

    public VWLaunchAppHelper(VWBaseAppLauncherApplet launcherApplet) {
        this.m_launcherApplet = launcherApplet;
    }

    public void setState(int newState) throws VWException {
        if (this.m_nState != 0) {
            throw new VWException("vw.apps.coordinator.StateNotNone", "The current state is not ''NONE''");
        }
        switch (newState) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 21: 
            case 22: {
                this.m_nState = newState;
                break;
            }
            default: {
                throw new VWException("vw.apps.coordinator.InvalidState", "The new state is invalid!");
            }
        }
    }

    public void run() {
        try {
            switch (this.m_nState) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.createApplication();
                    break;
                }
                case 21: {
                    if (!this.m_launcherApplet.logoff()) break;
                    VWIDMBaseFactory.instance().release();
                    VWCachedSecurityList.reset();
                    break;
                }
                case 22: {
                    this.m_launcherApplet.simpleLogoff();
                    VWIDMBaseFactory.instance().release();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_nState = 0;
    }

    private void createApplication() {
        VWSessionInfo sessionInfo = null;
        IVWLaunchableApp app = null;
        try {
            sessionInfo = this.m_launcherApplet.getSessionInfo();
            switch (this.m_nState) {
                case 1: {
                    if (!sessionInfo.verifyLogon(VWResource.s_pwAdministratorGroup)) {
                        return;
                    }
                    app = new VWAdminApplication();
                    break;
                }
                case 2: {
                    if (!sessionInfo.verifyLogon(VWResource.s_pwConfigurationGroup)) {
                        return;
                    }
                    app = new VWConfigApplication();
                    break;
                }
                case 3: {
                    if (!sessionInfo.verifyLogon(VWResource.s_pwDesignerGroup)) {
                        return;
                    }
                    app = new VWDesignerApplication();
                    break;
                }
                case 4: {
                    if (!sessionInfo.verifyLogon(null)) {
                        return;
                    }
                    app = new VWLinkerApplication();
                    break;
                }
                case 5: {
                    if (!sessionInfo.verifyLogon(null)) {
                        return;
                    }
                    app = new VWWorkflowManagerApplication();
                    break;
                }
                case 6: {
                    app = (IVWLaunchableApp)Class.forName("com.filenet.wcm.apps.client.publish.ui.WcmPublishAuthApplication").newInstance();
                    break;
                }
                case 7: {
                    app = (IVWLaunchableApp)Class.forName("com.filenet.wcm.apps.client.search.ui.WcmSearchAuthApplication").newInstance();
                    break;
                }
                case 8: {
                    if (!sessionInfo.verifyLogon(null)) {
                        return;
                    }
                    app = new VWSelectWFApplication();
                }
            }
            this.m_nState = 0;
            if (app == null) {
                return;
            }
            app.init(sessionInfo);
            this.m_launcherApplet.registerApplication(app);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

